'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Demonstration program for the Micromite+
' It does not do anything useful except demo the various controls
'
' Geoff Graham, October 2015
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Option Explicit
Dim ledsY
Colour RGB(white), RGB(black)
' reference numbers for the controls are defined as constants
Const c_head = 1, c_pmp = 2, sw_pmp = 3, c_flow = 4, tb_flow = 5
Const led_run = 6, led_alarm = 7
Const frm_alarm = 20, nbr_hi = 21, nbr_lo = 22, pb_test =23
Const c_hi = 24, c_lo = 25
Const frm_pump = 30, r_econ = 31, r_norm = 32, r_hi = 33
Const frm_log = 40, cb_enabled = 41, c_fname = 42, tb_fname = 43
Const c_log = 44, cb_flow = 45, cb_pwr = 46, cb_warn = 47
Const cb_alarm = 48, c_bright = 49, sb_bright = 50
' now draw the "Pump Control" display
CLS
GUI Interrupt TouchDown, TouchUp
' display the heading
Font 2 : GUI Caption c_head, "Pump Control", 10, 0
Font 2 : GUI Caption c_pmp, "Pump", 10, 25, , RGB(brown)
' now, define and display the controls
' first display the switch
Font 2
GUI Switch sw_pmp, "ON|OFF", 10, 45, 70, 30, RGB(white),RGB(brown)
CtrlVal(sw_pmp) = 1
' the flow rate display box
Font 2 : GUI Caption c_flow, "Flow Rate", 5, 75,, RGB(brown),0
Font 2 : GUI Displaybox tb_flow, 5, 100, 105, 25
CtrlVal(tb_flow) = "20.1"
' the radio buttons and their frame
Font 2 : GUI Frame frm_pump, "Power", 5, 140, 105, 90,RGB(200,20,255)
Font 1
GUI Radio r_econ, "Economy", 10, 150, 25, RGB(230, 230, 255)
GUI Radio r_norm, "Normal", 10, 175
GUI Radio r_hi, "High", 10, 200
CtrlVal(r_norm) = 1 ' start with the "normal" button selected
' the alarm frame with two number boxes and a push button switch
Font 2 : GUI Frame frm_alarm, "Alarm", 115, 115, 90, 115,RGB(green)
Font 1
GUI Caption c_hi, "Hi:", 120, 150, LT, RGB(yellow)
GUI Numberbox nbr_hi, 150,MM.VPos-6,40,MM.FontHeight+6,RGB(yellow),RGB(64,64,64)
GUI Caption c_lo, "Lo:", 120, 175, LT, RGB(yellow),0
GUI Numberbox nbr_lo, 150,MM.VPos-6,40,MM.FontHeight+6,RGB(yellow),RGB(64,64,64)
GUI Button pb_test, "TEST", 125, 200, 70, 25,RGB(yellow), RGB(red)
CtrlVal(nbr_lo) = 15.7 : CtrlVal(nbr_hi) = 35.5
' draw the two LEDs
Const ledsX = 125, coff = 50 ' define their position
ledsY = 50 : GUI LED led_run, "Running", ledsX, ledsY, 16, RGB(green)
ledsY = ledsY+25 : GUI LED led_alarm, "Alarm", ledsX, ledsY, 16, RGB(red)
CtrlVal(led_run) = 1 ' the switch defaults to on so set the LED on
' the logging frame with check boxes and a text box
Colour RGB(cyan), 0
GUI Frame frm_log, "Log File", 210, 10, 110, 160, RGB(green),0
GUI Checkbox cb_enabled, "Log On", 215, 20, 20, RGB(cyan)
GUI Caption c_fname, "File Name", 215, 45
GUI Textbox tb_fname, 215, 60, 100, 20, RGB(cyan), RGB(64,64,64)
GUI Caption c_log, "Record:", 215, 85, , RGB(cyan), 0
GUI Checkbox cb_flow, "Flow", 220, 100, 20
GUI Checkbox cb_alarm, "Alarms", 220, 120, 20
GUI Checkbox cb_warn, "Warnings", 220, 140, 20
CtrlVal(cb_enabled) = 1
CtrlVal(tb_fname) = "LOGFILE.TXT"
' define and display the spinbox for controlling the backlight
GUI Caption c_bright, "Back Light", 230, 190,,RGB(200,200,255),0
GUI Spinbox sb_bright, 210, 210, 110, 25,,,10, 10, 100
CtrlVal(sb_bright) = 100
' All the controls have been defined and displayed. At this point
' the program could do some real work but because this is just a
' demo there is nothing to do. So it just sits in a loop.
Do : Loop
' the interrupt routine for touch down
' using a select case command it has a different process for each
' control
Sub TouchDown
Select Case Touch(REF) ' find out the control touched
Case cb_enabled ' the enable check box
If CtrlVal(cb_enabled) Then
GUI Restore c_fname, tb_fname, c_log, cb_flow, cb_alarm, cb_warn
Else
GUI Disable c_fname, tb_fname, c_log, cb_flow, cb_alarm, cb_warn
EndIf
Case sb_bright ' the brightness spin box
BackLight CtrlVal(sb_bright)
Case sw_pmp ' the pump on/off switch
CtrlVal(led_run) = CtrlVal(sw_pmp)
CtrlVal(tb_flow) = Str$(CtrlVal(sw_pmp) * 20.1)
CtrlVal(r_norm) = 1
Case pb_test ' the alarm test button
CtrlVal(led_alarm) = 1
GUI beep 250
Case r_econ ' the economy radio button
CtrlVal(tb_flow) = Str$(CtrlVal(sw_pmp) * 18.3)
Case r_norm ' the normal radio button
CtrlVal(tb_flow) = Str$(CtrlVal(sw_pmp) * 20.1)
Case r_hi ' the high radio button
CtrlVal(tb_flow) = Str$(CtrlVal(sw_pmp) * 23.7)
End Select
End Sub
' interrupt routine when the touch is removed
Sub TouchUp
Select Case Touch(LASTREF) ' use the last reference
Case pb_test ' was it the test button
CtrlVal(led_alarm) = 0 ' turn off the LED
End Select
End Sub
